
/************************************************************************
 *FILE:           amcontrol_clienthandler_fc_audioroutemanager.h
 *SW-COMPONENT:      AmRoutingPlugin
 *DESCRIPTION:    ClientHandler for fc_audioroutemanager
 *AUTHOR:         RBEI/ECG4 - Vyankatesh VD
 *COPYRIGHT:      RBEI
 *HISTORY:
 *20.08.2013      Rev 1.0     RBEI/ECG4 - Vyankatesh VD  Initial Revision
************************************************************************/

#ifndef INCLUDE_AMCONTROL_CLIENT_FC_AUD_ROUTE_MGR_HANDLER_H_IF
#define INCLUDE_AMCONTROL_CLIENT_FC_AUD_ROUTE_MGR_HANDLER_H_IF

/*
// use Application Help Library
#ifndef AHL_S_IMPORT_INTERFACE_GENERIC
   #define AHL_S_IMPORT_INTERFACE_GENERIC
   #include "ahl_if.h"
#endif
#include "inc_fi_main.h"
*/
//#include "CAmControlSenderBase.h"

class CAmControlSenderBase;

#include "IAmControlReceiverShadow.h"
#include "inc_fi_handler.h"

using namespace am;


class amcontrol_clienthandler_fc_audioroutemanager : public inc_fi_handler
{
private:
    struct rConnectionSet
    {
      am_Handle_s handle;
      am_sourceID_t sourceID;
      am_connectionID_t connectionID;
    };

   uint16_t m_RoutingReadyHandle;
   am::IAmControlReceiverShadow *m_pControlReceiverShadowInterface;
   CAmControlSenderBase* m_pControlSenderBase;

   virtual tVoid vOnServiceAvailable();
   void vOnSourceRouteActivity(amt_tclServiceData* poMessage);
   void vOnRequestAudioRoute(amt_tclServiceData* poMessage);
   void vOnSourceAvailability(amt_tclServiceData* poMessage);

public:
    //static tBool bServiceAvailable;
    bool m_bSeviceAvailable;

    //Wrapper function
    void vCopyDatatoFIMessageWrapper(amt_tclServiceData* poFIMsg,fi_tclTypeBase &oFIData);

   //Default Constructor
   amcontrol_clienthandler_fc_audioroutemanager(tVoid);
   amcontrol_clienthandler_fc_audioroutemanager(CAmControlSenderBase*,am::IAmControlReceiverShadow*);
   ~amcontrol_clienthandler_fc_audioroutemanager(tVoid);

   /****************************************************************************
                  Methods of this application
   ****************************************************************************/

   /****************************************************************************
   ** FUNCTION:   tVoid vSourceRouteActivity_Set();
   ****************************************************************************/
   /* DESCRIPTION:
   *   This function is called by AMRoutingPlugin to change the source
   *   by calling set property of "SourceRouteActivity" of fc_audioroutingManager
   ****************************************************************************/
   tVoid vSourceRouteActivity_Set(uint8_t source,uint8_t nextSource,uint8_t Resource,uint8_t Activity);

   /****************************************************************************
   **              Declare Message Map
   ****************************************************************************/
   /* DESCRIPTION:
   *   The message map is used to "redirect" incoming FI messages to
   *   dedicated handler functions
   ****************************************************************************/
   DECLARE_MSG_MAP(amcontrol_clienthandler_fc_audioroutemanager)
};

#endif //INCLUDE_AMCONTROL_CLIENT_FC_AUD_ROUTE_MGR_HANDLER_H_IF
